/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.debugtools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.network.PacketDumpBlockInfo;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.Tools;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.simple.SimpleChannel;

public class DumpBlockNBT {
    public static String dumpBlockNBT(@Nonnull Level world, @Nonnull BlockPos pos, boolean verbose) {
        BlockState state = world.m_8055_(pos);
        BlockEntity te = world.m_7702_(pos);
        Block block = state.m_60734_();
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("block", (JsonElement)new JsonPrimitive(Tools.getId(block).toString()));
        if (te != null) {
            jsonObject.add("teClass", (JsonElement)new JsonPrimitive(te.getClass().getCanonicalName()));
            CompoundTag tag = te.m_187482_();
            if (verbose) {
                String nbtJson = tag.toString();
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(nbtJson);
                jsonObject.add("nbt", element);
            } else {
                JsonArray array = new JsonArray();
                for (String key : tag.m_128431_()) {
                    array.add((JsonElement)new JsonPrimitive(key));
                }
                jsonObject.add("nbt", (JsonElement)array);
            }
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)jsonObject);
    }

    public static void dumpBlock(@Nullable SimpleChannel network, @Nonnull Level world, @Nonnull BlockPos pos, boolean verbose) {
        String output = DumpBlockNBT.dumpBlockNBT(world, pos, verbose);
        Logging.getLogger().log(org.apache.logging.log4j.Level.INFO, "### Client side ###");
        Logging.getLogger().log(org.apache.logging.log4j.Level.INFO, output);
        if (network != null) {
            network.sendToServer((Object)new PacketDumpBlockInfo(world, pos, verbose));
        }
    }

    public static void dumpFocusedBlock(@Nullable SimpleChannel network, @Nonnull Player player, boolean liquids, boolean verbose) {
        Vec3 start = player.m_20299_(1.0f);
        Vec3 vec31 = player.m_20252_(1.0f);
        float dist = 20.0f;
        Vec3 end = start.m_82520_(vec31.f_82479_ * (double)dist, vec31.f_82480_ * (double)dist, vec31.f_82481_ * (double)dist);
        ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, liquids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult result = player.m_20193_().m_45547_(context);
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        String output = DumpBlockNBT.dumpBlockNBT(player.m_20193_(), result.m_82425_(), verbose);
        Logging.getLogger().log(org.apache.logging.log4j.Level.INFO, "### Client side ###");
        Logging.getLogger().log(org.apache.logging.log4j.Level.INFO, output);
        if (network != null) {
            network.sendToServer((Object)new PacketDumpBlockInfo(player.m_20193_(), result.m_82425_(), verbose));
        }
    }
}

